<#ibiztemplate>
TARGET=PSDATAENTITY
</#ibiztemplate>
<#if de.getUserTag()?? && de.getUserTag()=='elasticsearch'>
package ${pub.getPKGCodeName()}.core.es.domain;

import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.annotation.Id;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import lombok.Data;

@Data
@Document(indexName = "${sys.codeName?lower_case}", type = "${item.codeName?lower_case}", shards = 5, replicas = 1)
public class ${item.codeName} implements Serializable {

    private static final long serialVersionUID = 1L;

    <#if de.getPSDEFields()??>
        <#comment>输出实体属性</#comment>
        <#list de.getPSDEFields() as defield>
            <#if defield.isPhisicalDEField()==true>
                <#assign privateCodeName = srfcaseformat(defield.getCodeName(),'l_u2lC') >
                <#assign javaType=srfr7javatype(defield.getStdDataType())>
                <#assign esType="FieldType.Text">
                <#if javaType=='Long'>
                    <#assign esType="FieldType.Long">
                <#elseif javaType=='Integer'>
                    <#assign esType="FieldType.Integer">
                <#elseif javaType=='Double'|| javaType=='BigDecimal'>
                    <#assign esType="FieldType.Double">
                <#elseif javaType=='Timestamp'>
                    <#assign esType="FieldType.Date">
                </#if>
                <#if defield.isKeyDEField()==true>
    @Id
                <#else>
    @Field(type = ${esType})
                </#if>
    private ${javaType} ${privateCodeName};
            </#if>
        </#list>
    </#if>
}
</#if>





